#!/usr/bin/env bash
################################################################################
# Read input options

usage()
{
	echo "usage: install [options]"
		echo
		echo "Options:"
		echo "  -h, --help            show this help message and exit"
		echo "  -y, --assumeyes       answer yes for all questions"
}

assumeyes=false
while [ "$1" != "" ]; do
	case $1 in
		-y | --assumeyes )      assumeyes=true
								;;
		-h | --help )           usage
								exit
								;;
		* )                     usage
								echo
								echo "Command line error: no such option: $1"
								exit 1
	esac
	shift
done

################################################################################

if [ $EUID -ne 0 ]; then
	echo "This script requires root or sudo privileges."
	exit 1
fi

apt-get update

DIR=$( cd "$( dirname "${BASH_SOURCE[0]}" )" && pwd )

for dep in $(cd ${DIR} && ls | grep -v install.sh); do
	if [ -x ${DIR}/${dep}/install.sh ]; then
		${DIR}/${dep}/install.sh ${assumeyes}
	fi
done
