#!/usr/bin/env bash

################################################################################

PYMODULE=pyOpenSSL

################################################################################

command_exists () {
    type "$1" &> /dev/null ;
}

################################################################################

if [ $EUID -ne 0 ]; then
	echo "This script requires root or sudo privileges."
	exit 1
fi

assumeyes=$1

package_installer="yum"
if $assumeyes ; then
	package_installer="yum -y"
fi

if ! command_exists pip ; then
	if ! $assumeyes ; then
		echo "Installing following packages:"
		echo "1) System Packages: python-pip, epel-release"
		read -p "Is this ok [y/N]: " input

		if [ "$input" != "y" ] && [ "$input" != "Y" ] ; then
			exit 0
		fi
	fi

	echo Installing epel-release
	${package_installer} install epel-release

	echo Installing pip
	${package_installer} install python-pip

	if ! command_exists pip ; then
		echo "Error while installing pip. Please install pip and run this installation again."
		exit 1
	fi
fi

if ! $assumeyes ; then
	echo "Installing following packages:"
	echo "1) System Packages: gcc, libffi-devel, python-devel, openssl-devel"
	echo "2) Python Packages: pyOpenSSL, cffi"
	read -p "Is this ok [y/N]: " input

	if [ "$input" != "y" ] && [ "$input" != "Y" ] ; then
		exit 0
	fi
fi

echo Installing gcc libffi-devel python-devel openssl-devel
${package_installer} install gcc libffi-devel python-devel openssl-devel

echo Installing cffi
pip install cffi

echo "Installing ${PYMODULE}>=16.0.0"
pip install "${PYMODULE}>=16.0.0"
