#!/usr/bin/env bash
################################################################################

PYMODULE=ply
PIPMODULE=ply
PACKAGE=python-ply
EL6_PACKAGE=python-ply-3.4-4.el6.noarch.rpm
# centos6 python-ply-3.4-4.el6.noarch.rpm
# centos7 python-ply-3.4-10.el7.noarch

################################################################################

if [ $EUID -ne 0 ]; then
	echo "This script requires root or sudo privileges."
	exit 1
fi

DIR=$( cd "$( dirname "${BASH_SOURCE[0]}" )" && pwd )

python <<EOF
try:
	import ${PYMODULE}
	import sys
	sys.exit(0)
except Exception as e:
	import sys
	sys.exit(1)
EOF
has_pymodule=$?

if [ $has_pymodule -eq 0 ]; then
	exit 0
fi

if [ -f /etc/os-release ]; then
	. /etc/os-release
fi

distro_id=${ID,,}
distro_version=${VERSION_ID}

case "$distro_id" in 
	*'centos'* | *'redhat'* | *'rhel'* )
		distro_id='el'
	;;
esac


case "$distro_id:$distro_version" in
	"el:7"* )
        echo Installing ${PACKAGE}
        yum install -y ${PACKAGE}
        ;;
    * )
        echo Installing ${EL6_PACKAGE}
		rpm -ivh ${DIR}/${EL6_PACKAGE}
        ;;
esac
