#!/usr/bin/env bash

################################################################################

PYMODULE=pyasn1

################################################################################

command_exists () {
    type "$1" &> /dev/null ;
}

################################################################################

if [ $EUID -ne 0 ]; then
	echo "This script requires root or sudo privileges."
	exit 1
fi

assumeyes=$1

package_installer="yum"
if $assumeyes ; then
	package_installer="yum -y"
fi

if ! command_exists pip ; then
	if ! $assumeyes ; then
		echo "Installing following packages:"
		echo "1) System Packages: python-pip, epel-release"
		read -p "Is this ok [y/N]: " input

		if [ "$input" != "y" ] && [ "$input" != "Y" ] ; then
			exit 0
		fi
	fi

	echo Installing epel-release
	${package_installer} install epel-release

	echo Installing pip
	${package_installer} install python-pip

	if ! command_exists pip ; then
		echo "Error while installing pip. Please install pip and run this installation again."
		exit 1
	fi
fi

if ! $assumeyes ; then
	echo "Installing following package:"
	echo "1) Python Package: pyasn1"
	read -p "Is this ok [y/N]: " input

	if [ "$input" != "y" ] && [ "$input" != "Y" ] ; then
		exit 0
	fi
fi

echo "Installing ${PYMODULE}>=0.3.1"
pip install "${PYMODULE}>=0.3.1"