#!/usr/bin/env bash

################################################################################

PYMODULE=jsonschema

PIP_PACKAGE=pip-9.0.1.tar.gz

################################################################################

command_exists () {
    type "$1" &> /dev/null ;
}

################################################################################

if [ $EUID -ne 0 ]; then
	echo "This script requires root or sudo privileges."
	exit 1
fi

python <<EOF
try:
	import ${PYMODULE}
	import sys
	sys.exit(0)
except Exception as e:
	import sys
	sys.exit(1)
EOF
has_pymodule=$?

if [ $has_pymodule -eq 0 ]; then
	exit 0
fi

if ! command_exists pip ; then
	echo Installing python-dev
	apt-get -y install python-dev

	echo Installing python-setuptools
	apt-get -y install python-setuptools

	DIR=$( cd "$( dirname "${BASH_SOURCE[0]}" )" && pwd )
	LIBS=${DIR}/../../libs

	echo Installing pip
	easy_install ${LIBS}/${PIP_PACKAGE}

	if ! command_exists pip ; then
		echo "Error while installing pip. Please install pip and run this installation again."
		exit 1
	fi
fi

echo "Installing ${PYMODULE}"
pip install ${PYMODULE}
