#!/usr/bin/env bash
################################################################################

PYMODULE=ply
PIPMODULE=ply
PACKAGE=python-ply
# debian7 wheezy python-ply                      3.4-3
# debian8 jessie python-ply                  3.4-5
# ubuntu12 precise python-ply                       3.4-2build1
# ubuntu14 trusty python-ply                       3.4-3ubuntu2
# ubuntu16 xenial python-ply                  3.7-1


################################################################################

if [ $EUID -ne 0 ]; then
	echo "This script requires root or sudo privileges."
	exit 1
fi

DIR=$( cd "$( dirname "${BASH_SOURCE[0]}" )" && pwd )

python <<EOF
try:
	import ${PYMODULE}
	import sys
	sys.exit(0)
except Exception as e:
	import sys
	sys.exit(1)
EOF
has_pymodule=$?

if [ $has_pymodule -eq 0 ]; then
	exit 0
fi

if [ -f /etc/os-release ]; then
	. /etc/os-release
fi

distro_id=${ID,,}
distro_version=${VERSION_ID}

case "$distro_id:$distro_version" in
	* )
		echo Installing ${PACKAGE}
		apt-get install -y ${PACKAGE}
		;;
esac
