#!/usr/bin/env bash
################################################################################
# Read input options

usage()
{
	echo "usage: install [options]"
		echo
		echo "Options:"
		echo "  -h, --help            show this help message and exit"
		echo "  -o, --optional        run optional dependency scripts"
		echo "  -y, --assumeyes       answer yes for all questions"
}

assumeyes=false
run_optional_scripts=false
while [ "$1" != "" ]; do
	case $1 in
		-o | --optional  )      run_optional_scripts=true
								;;
		-y | --assumeyes )      assumeyes=true
								;;
		-h | --help )           usage
								exit
								;;
		* )                     usage
								echo
								echo "Command line error: no such option: $1"
								exit 1
	esac
	shift
done

################################################################################

if [ $EUID -ne 0 ]; then
	echo "This script requires root or sudo privileges."
	exit 1
fi

DIR=$( cd "$( dirname "${BASH_SOURCE[0]}" )" && pwd )

if $run_optional_scripts ; then
	install_script=${DIR}/deps-optional/install.sh
	if [ -x ${install_script} ]; then
		if $assumeyes ; then
			${install_script} -y
		else
			${install_script}
		fi
	fi
else
	install_script=${DIR}/deps/install.sh
	if [ -x ${install_script} ]; then
		${install_script}
	fi
fi
