# Aerospike Telemetry Agent Documentation

The Aerospike Telemetry Agent collects anonymized usage statistics from an Aerospike server running on the same machine and forwards the data so obtained to Aerospike.

## Theory of Operation

The usage statistics are obtained via sending various Info. commands to the Aerospike server on its service port. The Aerospike server's service port is determined by parsing the Aerospike server configuration file, which must be provided as the value of the `config-file` property in the `[asd]` section of the Telemetry Agent configuration file. Some basic system-level statistics are also obtained from the host machine.

## Running the Telemetry Agent

1). Use Git to clone the `aerospike-telemetry-agent` repository.

2). `cd aerospike-telemetry-agent`

3). You may run `python ./telemetry.py --help` for usage:

```
$ python ./telemetry.py --help
Usage: ./telemetry.py [options] <ConfigFile> [<Service Action for Daemon Mode: (start|stop|status|restart|try-restart)>]

Options:
  -h, --help            show this help message and exit
  --disable             Disable Telemetry Agent. (Requires agent restart to
                        take effect.)
  --enable              Enable Telemetry Agent. (Requires agent restart to
                        take effect.)
  --fgdaemon            Enable foreground daemon mode.
  --set-cafile=<CAFILE>
                        Set certificate authority file.
  --set-email=<EMAIL>   Set email address.
  --set-group=<GROUP>   Set daemon group.
  --set-interval=<INTERVAL>
                        Set data collection and reporting interval.
  --set-logfile=<LOGFILE>
                        Set log file.
  --set-loglevel=<LOGLEVEL>
                        Set log level.
  --set-proxy=<PROXY>   Set HTTPS proxy.
  --set-user=<USER>     Set daemon user.
```

4). The single required argument is the Telemetry Agent configuration file.

For reference purposes, a example configuration file is provided as `telemetry_sample.conf`. (The 'real' generally comes from the Aerospike server source code tree.)

5). You may supply a command-line option to edit the configuration file.

Example usage:

```
$ python ./telemetry.py telemetry.conf --set-logfile=out
```

6). Otherwise, you must supply a service action (`start`, `stop`, `status`, `restart`, or `try-restart`) for running the Telemetry Agent as a daemon.

Example usage:

```
$ python ./telemetry.py telemetry.conf start
```

**Note**:  The `--fgdaemon` option is used with the `start` command under `systemd` to run the Telemetry Agent as a "new style" (foreground) daemon.

## Configuration

The Telemetry Agent uses the parameters present in the configuration file. These parameters can be changed by directly editing the configuration file or by using the command line tool as detailed in the usage output above.

A sample development configuration file might look like:

```
[asd]
config-file = /etc/aerospike/aerospike.conf

[logging]
logfile = out
loglevel = debug

[main]
disable = false
interval = 600
home-url = https://telemetry.aerospike.com
email =
user = aerospike
group = aerospike
```

## Disabling/Enabling the Telemetry Agent

There are two ways to disable/enable the Telemetry Agent:

1). Directly edit the configuration file.

 When ASD is installed via a DEB or RPM package, the configuration file is stored as: `/etc/aerospike/telemetry.conf`.

To disable (or enable) the agent, set the `disable` value in the file to `true` (or `false`.)

2). Use the Telemetry Agent command line interface.

When ASD is installed via a DEB or RPM package, the main Telemetry Agent script is stored as: `/opt/aerospike/telemetry/telemetry.py`.

To disable (or enable) the Telemetry Agent, run:

	$ python /opt/aerospike/telemetry/telemetry.py /etc/aerospike/telemetry.conf --disable

or

	$ python /opt/aerospike/telemetry/telemetry.py /etc/aerospike/telemetry.conf --enable

If you're running from within the repository, run:

	$ python <repo path>/modules/telemetry/telemetry.py <repo path>/as/etc/telemetry_dev.conf --disable

or

	$ python <repo path>/modules/telemetry/telemetry.py <repo path>/as/etc/telemetry_dev.conf --enable

If Aerospike is already running when using either of the above methods, you must restart Aerospike (or just the Telemetry Agent) for the change to take effect:

On most distros (based on SysV Init.), use:

	$ service aerospike restart

or

	$ service aerospike_telemetry restart

Under `systemd`-based distros (RedHat EL7-based distros (e.g., RHEL 7, CentOS 7, Fedora 15+), Debian 8, and Ubuntu 16.04), use:

	$ systemctl restart aerospike

or

	$ systemctl restart aerospike_telemetry

or, when ASD is run from within the open source tree (i.e., GitHub repo.):

	$ make stop start

## Data Format

The following is an example of the format of the data sent from the Telemetry Agent to Aerospike:
[*Note:*  Not all fields are sent at all times.  Infrequently-changing or
potentially-verbose fields (specifically, `config`, `sets`, `sindex-metadata`,
`sindexes`, and `system`) are generally sent only once per day.]

	{ 'config': { 'allow-inline-transactions': 'true',
	              'batch-index-threads': '4',
	              'batch-max-buffers-per-queue': '255',
	              'batch-max-requests': '5000',
	              'batch-max-unused-buffers': '256',
	              'batch-priority': '200',
	              'batch-threads': '4',
	              'enable-security': 'false',
	              'enable-xdr': 'false',
	              'fabric-keepalive-enabled': 'true',
	              'fabric-keepalive-intvl': '1',
	              'fabric-keepalive-probes': '10',
	              'fabric-keepalive-time': '1',
	              'fabric-port': '3001',
	              'fabric-workers': '16',
	              'forward-xdr-writes': 'false',
	              'heartbeat-address': '5e4a8105ba09c5dde3bc8f9db4b7ae0d',
	              'heartbeat-interval': '150',
	              'heartbeat-mode': 'multicast',
	              'heartbeat-port': '9123',
	              'heartbeat-protocol': 'v2',
	              'heartbeat-timeout': '10',
	              'info-threads': '16',
	              'ldt-benchmarks': 'false',
	              'log-local-time': 'false',
	              'max-msgs-per-type': '-1',
	              'memory-accounting': 'false',
	              'microbenchmarks': 'false',
	              'migrate-max-num-incoming': '256',
	              'migrate-read-priority': '10',
	              'migrate-read-sleep': '500',
	              'migrate-rx-lifetime-ms': '60000',
	              'migrate-threads': '1',
	              'migrate-xmit-hwm': '10',
	              'migrate-xmit-lwm': '5',
	              'migrate-xmit-priority': '40',
	              'migrate-xmit-sleep': '500',
	              'network-info-port': '3003',
	              'nsup-delete-sleep': '100',
	              'nsup-period': '120',
	              'nsup-startup-evict': 'true',
	              'paxos-max-cluster-size': '32',
	              'paxos-protocol': 'v3',
	              'paxos-recovery-policy': 'manual',
	              'paxos-retransmit-period': '5',
	              'paxos-single-replica-limit': '1',
	              'pidfile': '/var/run/aerospike/asd.pid',
	              'privilege-refresh-period': '300',
	              'prole-extra-ttl': '0',
	              'proto-fd-idle-ms': '60000',
	              'proto-fd-max': '15000',
	              'proto-slow-netio-sleep-ms': '1',
	              'proxy-hist-track-back': '1800',
	              'proxy-hist-track-slice': '10',
	              'proxy-hist-track-thresholds': '1,8,64',
	              'query-batch-size': '100',
	              'query-bufpool-size': '256',
	              'query-hist-track-back': '1800',
	              'query-hist-track-slice': '10',
	              'query-hist-track-thresholds': '1,8,64',
	              'query-in-transaction-thread': '0',
	              'query-long-q-max-size': '500',
	              'query-pre-reserve-partitions': 'false',
	              'query-priority': '10',
	              'query-priority-sleep-us': '1',
	              'query-rec-count-bound': '18446744073709551615',
	              'query-req-in-query-thread': '0',
	              'query-req-max-inflight': '100',
	              'query-short-q-max-size': '500',
	              'query-threads': '6',
	              'query-threshold': '10',
	              'query-untracked-time-ms': '1000',
	              'query-worker-threads': '15',
	              'query_rec_count-hist-track-back': '1800',
	              'query_rec_count-hist-track-slice': '10',
	              'query_rec_count-hist-track-thresholds': '1,8,64',
	              'reads-hist-track-back': '1800',
	              'reads-hist-track-slice': '10',
	              'reads-hist-track-thresholds': '1,8,64',
	              'replication-fire-and-forget': 'false',
	              'report-authentication-sinks': '0',
	              'report-data-op-sinks': '0',
	              'report-sys-admin-sinks': '0',
	              'report-user-admin-sinks': '0',
	              'report-violation-sinks': '0',
	              'respond-client-on-master-completion': 'false',
	              'reuse-address': 'true',
	              'scan-max-active': '100',
	              'scan-max-done': '100',
	              'scan-max-udf-transactions': '32',
	              'scan-threads': '4',
	              'service-address': 'f1f17934834ae2613699701054ef9684',
	              'service-port': '3000',
	              'service-threads': '4',
	              'sindex-builder-threads': '4',
	              'sindex-data-max-memory': 'ULONG_MAX',
	              'snub-nodes': 'false',
	              'stop-writes-noxdr': 'false',
	              'storage-benchmarks': 'false',
	              'syslog-local': '-1',
	              'ticker-interval': '10',
	              'transaction-duplicate-threads': '0',
	              'transaction-max-ms': '1000',
	              'transaction-pending-limit': '20',
	              'transaction-queues': '4',
	              'transaction-repeatable-read': 'false',
	              'transaction-retry-ms': '1000',
	              'transaction-threads-per-queue': '4',
	              'udf-hist-track-back': '1800',
	              'udf-hist-track-slice': '10',
	              'udf-hist-track-thresholds': '1,8,64',
	              'udf-runtime-gmax-memory': '18446744073709551615',
	              'udf-runtime-max-memory': '18446744073709551615',
	              'use-queue-per-device': 'false',
	              'write-duplicate-resolution-disable': 'false',
	              'writes_master-hist-track-back': '1800',
	              'writes_master-hist-track-slice': '10',
	              'writes_master-hist-track-thresholds': '1,8,64',
	              'xdr-delete-shipping-enabled': 'true',
	              'xdr-namedpipe-path': 'NULL',
	              'xdr-nsup-deletes-enabled': 'false'},
	  'interval': '600',
	  'meminfo': { 'Active': '521784 kB',
	               'Active(anon)': '200540 kB',
	               'Active(file)': '321244 kB',
	               'AnonHugePages': '124928 kB',
	               'AnonPages': '200028 kB',
	               'Bounce': '0 kB',
	               'Buffers': '178672 kB',
	               'Cached': '377348 kB',
	               'CommitLimit': '81986524 kB',
	               'Committed_AS': '5586880 kB',
	               'DirectMap2M': '33445888 kB',
	               'DirectMap4k': '8192 kB',
	               'Dirty': '360 kB',
	               'HardwareCorrupted': '0 kB',
	               'HugePages_Free': '0',
	               'HugePages_Rsvd': '0',
	               'HugePages_Surp': '0',
	               'HugePages_Total': '0',
	               'Hugepagesize': '2048 kB',
	               'Inactive': '234500 kB',
	               'Inactive(anon)': '3784 kB',
	               'Inactive(file)': '230716 kB',
	               'KernelStack': '2232 kB',
	               'Mapped': '24776 kB',
	               'MemFree': '31640996 kB',
	               'MemTotal': '32898740 kB',
	               'Mlocked': '0 kB',
	               'NFS_Unstable': '0 kB',
	               'PageTables': '6700 kB',
	               'SReclaimable': '73760 kB',
	               'SUnreclaim': '27392 kB',
	               'Shmem': '4080 kB',
	               'Slab': '101152 kB',
	               'SwapCached': '0 kB',
	               'SwapFree': '65537156 kB',
	               'SwapTotal': '65537156 kB',
	               'Unevictable': '0 kB',
	               'VmallocChunk': '34359311436 kB',
	               'VmallocTotal': '34359738367 kB',
	               'VmallocUsed': '422552 kB',
	               'Writeback': '0 kB',
	               'WritebackTmp': '0 kB'},
	  'namespaces': { '098f6bcd4621d373cade4e832627b4f6': { 'allow-nonxdr-writes': 'true',
	                                                        'allow-xdr-writes': 'true',
	                                                        'available-bin-names': '32763',
	                                                        'cold-start-evict-ttl': '4294967295',
	                                                        'conflict-resolution-policy': 'generation',
	                                                        'current-time': '194838263',
	                                                        'data-used-bytes-memory': '2103753',
	                                                        'default-ttl': '2592000',
	                                                        'disallow-null-setname': 'false',
	                                                        'enable-xdr': 'false',
	                                                        'evict-tenths-pct': '5',
	                                                        'evicted-objects': '0',
	                                                        'expired-objects': '0',
	                                                        'free-pct-memory': '99',
	                                                        'high-water-disk-pct': '50',
	                                                        'high-water-memory-pct': '60',
	                                                        'hwm-breached': 'false',
	                                                        'index-used-bytes-memory': '1490496',
	                                                        'ldt-enabled': 'false',
	                                                        'ldt-page-size': '8192',
	                                                        'master-objects': '12013',
	                                                        'master-sub-objects': '0',
	                                                        'max-ttl': '0',
	                                                        'max-void-time': '197430245',
	                                                        'memory-size': '4294967296',
	                                                        'migrate-rx-partitions-initial': '0',
	                                                        'migrate-rx-partitions-remaining': '0',
	                                                        'migrate-tx-partitions-imbalance': '0',
	                                                        'migrate-tx-partitions-initial': '0',
	                                                        'migrate-tx-partitions-remaining': '0',
	                                                        'non-expirable-objects': '0',
	                                                        'ns-forward-xdr-writes': 'false',
	                                                        'nsup-cycle-duration': '0',
	                                                        'nsup-cycle-sleep-pct': '0',
	                                                        'objects': '23289',
	                                                        'prole-objects': '11276',
	                                                        'prole-sub-objects': '0',
	                                                        'read-consistency-level-override': 'off',
	                                                        'repl-factor': '2',
	                                                        'set-deleted-objects': '0',
	                                                        'sets-enable-xdr': 'true',
	                                                        'sindex-used-bytes-memory': '73984',
	                                                        'single-bin': 'false',
	                                                        'stop-writes': 'false',
	                                                        'stop-writes-pct': '90',
	                                                        'sub-objects': '0',
	                                                        'total-bytes-memory': '4294967296',
	                                                        'type': 'memory',
	                                                        'used-bytes-memory': '3668233',
	                                                        'write-commit-level-override': 'off'},
	                  '37b51d194a7513e45b56f6524f2d51f2': { 'allow-nonxdr-writes': 'true',
	                                                        'allow-xdr-writes': 'true',
	                                                        'available-bin-names': '32768',
	                                                        'cold-start-evict-ttl': '4294967295',
	                                                        'conflict-resolution-policy': 'generation',
	                                                        'current-time': '194838263',
	                                                        'data-used-bytes-memory': '0',
	                                                        'default-ttl': '2592000',
	                                                        'disallow-null-setname': 'false',
	                                                        'enable-xdr': 'false',
	                                                        'evict-tenths-pct': '5',
	                                                        'evicted-objects': '0',
	                                                        'expired-objects': '0',
	                                                        'free-pct-memory': '100',
	                                                        'high-water-disk-pct': '50',
	                                                        'high-water-memory-pct': '60',
	                                                        'hwm-breached': 'false',
	                                                        'index-used-bytes-memory': '0',
	                                                        'ldt-enabled': 'false',
	                                                        'ldt-page-size': '8192',
	                                                        'master-objects': '0',
	                                                        'master-sub-objects': '0',
	                                                        'max-ttl': '0',
	                                                        'max-void-time': '0',
	                                                        'memory-size': '4294967296',
	                                                        'migrate-rx-partitions-initial': '0',
	                                                        'migrate-rx-partitions-remaining': '0',
	                                                        'migrate-tx-partitions-imbalance': '0',
	                                                        'migrate-tx-partitions-initial': '0',
	                                                        'migrate-tx-partitions-remaining': '0',
	                                                        'non-expirable-objects': '0',
	                                                        'ns-forward-xdr-writes': 'false',
	                                                        'nsup-cycle-duration': '0',
	                                                        'nsup-cycle-sleep-pct': '0',
	                                                        'objects': '0',
	                                                        'prole-objects': '0',
	                                                        'prole-sub-objects': '0',
	                                                        'read-consistency-level-override': 'off',
	                                                        'repl-factor': '2',
	                                                        'set-deleted-objects': '0',
	                                                        'sets-enable-xdr': 'true',
	                                                        'sindex-used-bytes-memory': '0',
	                                                        'single-bin': 'false',
	                                                        'stop-writes': 'false',
	                                                        'stop-writes-pct': '90',
	                                                        'sub-objects': '0',
	                                                        'total-bytes-memory': '4294967296',
	                                                        'type': 'memory',
	                                                        'used-bytes-memory': '0',
	                                                        'write-commit-level-override': 'off'}},
	  'node': '3001:efba5fc8eb3db7fff983c6fc82ccf177',
	  'queries': { 'latency': 'query:01:44:05-GMT,ops/sec,>1ms,>8ms,>64ms;01:44:15,0.0,0.00,0.00,0.00;',
	               'throughput': 'query:01:44:05-GMT,ops/sec;01:44:15,0.0;'},
	  'service': '0db488a85bf519ebd3d5c8e16ecaf097:3000',
	  'services': '44dde01af2643694c082906e5ef73f14:3000;a780fd5a2df6e68501d9b88b4e0fb4ca:3000',
	  'services-alternate': '',
	  'services-alumni': '44dde01af2643694c082906e5ef73f14:3000;a780fd5a2df6e68501d9b88b4e0fb4ca:3000',
	  'sets': [ { 'disable-eviction': 'false',
	              'n-bytes-memory': '639761',
	              'n_objects': '7009',
	              'ns_name': '098f6bcd4621d373cade4e832627b4f6',
	              'set-delete': 'false',
	              'set-enable-xdr': 'use-default',
	              'set_name': '92d75a4b1d78633cc12560b736d37009',
	              'stop-writes-count': '0'},
	            { 'disable-eviction': 'false',
	              'n-bytes-memory': '1201730',
	              'n_objects': '13334',
	              'ns_name': '098f6bcd4621d373cade4e832627b4f6',
	              'set-delete': 'false',
	              'set-enable-xdr': 'use-default',
	              'set_name': 'c20fdf5a752e4f2b0606222a3bf6fd81',
	              'stop-writes-count': '0'},
	            { 'disable-eviction': 'false',
	              'n-bytes-memory': '262262',
	              'n_objects': '2946',
	              'ns_name': '098f6bcd4621d373cade4e832627b4f6',
	              'set-delete': 'false',
	              'set-enable-xdr': 'use-default',
	              'set_name': 'c643305ccf044b0ab3a396618fbedaca',
	              'stop-writes-count': '0'}],
	  'sindex-metadata': [ { 'bin': '8277e0910d750195b448797616e091ad',
	                         'indexname': '9eb81a20a34d7e125a5c288f9696731c',
	                         'indextype': 'NONE',
	                         'ns': '098f6bcd4621d373cade4e832627b4f6',
	                         'path': '8277e0910d750195b448797616e091ad',
	                         'set': '098f6bcd4621d373cade4e832627b4f6',
	                         'state': 'RW',
	                         'sync_state': 'synced',
	                         'type': 'NUMERIC'},
	                       { 'bin': '0cc175b9c0f1b6a831c399e269772661',
	                         'indexname': '409769f6d6bd2a1fe9e3fa6e819c3f90',
	                         'indextype': 'NONE',
	                         'ns': '098f6bcd4621d373cade4e832627b4f6',
	                         'path': '0cc175b9c0f1b6a831c399e269772661',
	                         'set': '098f6bcd4621d373cade4e832627b4f6',
	                         'state': 'RW',
	                         'sync_state': 'synced',
	                         'type': 'STRING'},
	                       { 'bin': '92eb5ffee6ae2fec3ad71c777531578f',
	                         'indexname': '3af951ba6c816d58d809f1f119eb3832',
	                         'indextype': 'NONE',
	                         'ns': '098f6bcd4621d373cade4e832627b4f6',
	                         'path': '92eb5ffee6ae2fec3ad71c777531578f',
	                         'set': '098f6bcd4621d373cade4e832627b4f6',
	                         'state': 'RW',
	                         'sync_state': 'synced',
	                         'type': 'NUMERIC'},
	                       { 'bin': '4a8a08f09d37b73795649038408b5f33',
	                         'indexname': '0ba90b00473d5b1ccab3a8d049da57c5',
	                         'indextype': 'NONE',
	                         'ns': '098f6bcd4621d373cade4e832627b4f6',
	                         'path': '4a8a08f09d37b73795649038408b5f33',
	                         'set': '098f6bcd4621d373cade4e832627b4f6',
	                         'state': 'RW',
	                         'sync_state': 'synced',
	                         'type': 'NUMERIC'}],
	  'sindexes': { '0ba90b00473d5b1ccab3a8d049da57c5': { 'data-max-memory': 'ULONG_MAX',
	                                                      'gc-max-units': '1000',
	                                                      'gc-period': '1000',
	                                                      'histogram': 'false',
	                                                      'ibtr_memory_used': '18432',
	                                                      'ignore-not-sync': 'true',
	                                                      'keys': '0',
	                                                      'load_pct': '100',
	                                                      'loadtime': '0',
	                                                      'nbtr_memory_used': '0',
	                                                      'objects': '0',
	                                                      'query_agg': '0',
	                                                      'query_agg_avg_rec_count': '0',
	                                                      'query_agg_avg_record_size': '0',
	                                                      'query_avg_rec_count': '0',
	                                                      'query_avg_record_size': '0',
	                                                      'query_lookup_avg_rec_count': '0',
	                                                      'query_lookup_avg_record_size': '0',
	                                                      'query_lookups': '0',
	                                                      'query_reqs': '0',
	                                                      'si_accounted_memory': '18432',
	                                                      'stat_delete_errs': '0',
	                                                      'stat_delete_reqs': '0',
	                                                      'stat_delete_success': '0',
	                                                      'stat_gc_recs': '0',
	                                                      'stat_gc_time': '0',
	                                                      'stat_write_errs': '0',
	                                                      'stat_write_reqs': '0',
	                                                      'stat_write_success': '0'},
	                '3af951ba6c816d58d809f1f119eb3832': { 'data-max-memory': 'ULONG_MAX',
	                                                      'gc-max-units': '1000',
	                                                      'gc-period': '1000',
	                                                      'histogram': 'false',
	                                                      'ibtr_memory_used': '18432',
	                                                      'ignore-not-sync': 'true',
	                                                      'keys': '0',
	                                                      'load_pct': '100',
	                                                      'loadtime': '0',
	                                                      'nbtr_memory_used': '0',
	                                                      'objects': '0',
	                                                      'query_agg': '0',
	                                                      'query_agg_avg_rec_count': '0',
	                                                      'query_agg_avg_record_size': '0',
	                                                      'query_avg_rec_count': '0',
	                                                      'query_avg_record_size': '0',
	                                                      'query_lookup_avg_rec_count': '0',
	                                                      'query_lookup_avg_record_size': '0',
	                                                      'query_lookups': '0',
	                                                      'query_reqs': '0',
	                                                      'si_accounted_memory': '18432',
	                                                      'stat_delete_errs': '0',
	                                                      'stat_delete_reqs': '0',
	                                                      'stat_delete_success': '0',
	                                                      'stat_gc_recs': '0',
	                                                      'stat_gc_time': '0',
	                                                      'stat_write_errs': '0',
	                                                      'stat_write_reqs': '0',
	                                                      'stat_write_success': '0'},
	                '409769f6d6bd2a1fe9e3fa6e819c3f90': { 'data-max-memory': 'ULONG_MAX',
	                                                      'gc-max-units': '1000',
	                                                      'gc-period': '1000',
	                                                      'histogram': 'false',
	                                                      'ibtr_memory_used': '18688',
	                                                      'ignore-not-sync': 'true',
	                                                      'keys': '0',
	                                                      'load_pct': '100',
	                                                      'loadtime': '0',
	                                                      'nbtr_memory_used': '0',
	                                                      'objects': '0',
	                                                      'query_agg': '0',
	                                                      'query_agg_avg_rec_count': '0',
	                                                      'query_agg_avg_record_size': '0',
	                                                      'query_avg_rec_count': '0',
	                                                      'query_avg_record_size': '0',
	                                                      'query_lookup_avg_rec_count': '0',
	                                                      'query_lookup_avg_record_size': '0',
	                                                      'query_lookups': '0',
	                                                      'query_reqs': '0',
	                                                      'si_accounted_memory': '18688',
	                                                      'stat_delete_errs': '0',
	                                                      'stat_delete_reqs': '0',
	                                                      'stat_delete_success': '0',
	                                                      'stat_gc_recs': '0',
	                                                      'stat_gc_time': '0',
	                                                      'stat_write_errs': '0',
	                                                      'stat_write_reqs': '0',
	                                                      'stat_write_success': '0'},
	                '9eb81a20a34d7e125a5c288f9696731c': { 'data-max-memory': 'ULONG_MAX',
	                                                      'gc-max-units': '1000',
	                                                      'gc-period': '1000',
	                                                      'histogram': 'false',
	                                                      'ibtr_memory_used': '18432',
	                                                      'ignore-not-sync': 'true',
	                                                      'keys': '0',
	                                                      'load_pct': '100',
	                                                      'loadtime': '0',
	                                                      'nbtr_memory_used': '0',
	                                                      'objects': '0',
	                                                      'query_agg': '0',
	                                                      'query_agg_avg_rec_count': '0',
	                                                      'query_agg_avg_record_size': '0',
	                                                      'query_avg_rec_count': '0',
	                                                      'query_avg_record_size': '0',
	                                                      'query_lookup_avg_rec_count': '0',
	                                                      'query_lookup_avg_record_size': '0',
	                                                      'query_lookups': '0',
	                                                      'query_reqs': '0',
	                                                      'si_accounted_memory': '18432',
	                                                      'stat_delete_errs': '0',
	                                                      'stat_delete_reqs': '0',
	                                                      'stat_delete_success': '0',
	                                                      'stat_gc_recs': '0',
	                                                      'stat_gc_time': '0',
	                                                      'stat_write_errs': '0',
	                                                      'stat_write_reqs': '0',
	                                                      'stat_write_success': '0'}},
	  'statistics': { 'aggr_scans_failed': '0',
	                  'aggr_scans_succeeded': '0',
	                  'basic_scans_failed': '0',
	                  'basic_scans_succeeded': '0',
	                  'batch_errors': '0',
	                  'batch_index_complete': '0',
	                  'batch_index_created_buffers': '0',
	                  'batch_index_destroyed_buffers': '0',
	                  'batch_index_errors': '0',
	                  'batch_index_huge_buffers': '0',
	                  'batch_index_initiate': '0',
	                  'batch_index_queue': '0:0,0:0,0:0,0:0',
	                  'batch_index_timeout': '0',
	                  'batch_index_unused_buffers': '0',
	                  'batch_initiate': '0',
	                  'batch_queue': '0',
	                  'batch_timeout': '0',
	                  'batch_tree_count': '0',
	                  'client_connections': '3',
	                  'cluster_integrity': 'true',
	                  'cluster_key': '5AFE4DC04EB9BEE1',
	                  'cluster_size': '3',
	                  'data-used-bytes-memory': '2103753',
	                  'delete_queue': '0',
	                  'err_duplicate_proxy_request': '0',
	                  'err_out_of_space': '0',
	                  'err_replica_non_null_node': '0',
	                  'err_replica_null_node': '0',
	                  'err_rw_cant_put_unique': '0',
	                  'err_rw_pending_limit': '0',
	                  'err_rw_request_not_found': '0',
	                  'err_storage_queue_full': '0',
	                  'err_sync_copy_null_master': '0',
	                  'err_tsvc_requests': '0',
	                  'err_tsvc_requests_timeout': '0',
	                  'err_write_fail_bin_exists': '0',
	                  'err_write_fail_bin_name': '0',
	                  'err_write_fail_bin_not_found': '0',
	                  'err_write_fail_forbidden': '0',
	                  'err_write_fail_generation': '0',
	                  'err_write_fail_generation_xdr': '0',
	                  'err_write_fail_incompatible_type': '0',
	                  'err_write_fail_key_exists': '0',
	                  'err_write_fail_key_mismatch': '0',
	                  'err_write_fail_not_found': '0',
	                  'err_write_fail_noxdr': '0',
	                  'err_write_fail_parameter': '0',
	                  'err_write_fail_prole_delete': '0',
	                  'err_write_fail_prole_generation': '0',
	                  'err_write_fail_prole_unknown': '0',
	                  'err_write_fail_record_too_big': '0',
	                  'err_write_fail_unknown': '0',
	                  'fabric_msgs_rcvd': '40907',
	                  'fabric_msgs_sent': '40909',
	                  'free-pct-disk': '0',
	                  'free-pct-memory': '99',
	                  'geo_region_query_cells': '0',
	                  'geo_region_query_count': '0',
	                  'geo_region_query_falsepos': '0',
	                  'geo_region_query_points': '0',
	                  'heartbeat_received_foreign': '313874',
	                  'heartbeat_received_self': '156938',
	                  'index-used-bytes-memory': '1490496',
	                  'info_queue': '0',
	                  'migrate_msgs_recv': '0',
	                  'migrate_msgs_sent': '0',
	                  'migrate_num_incoming_accepted': '0',
	                  'migrate_num_incoming_refused': '0',
	                  'migrate_progress_recv': '0',
	                  'migrate_progress_send': '0',
	                  'migrate_rx_objs': '0',
	                  'migrate_tx_objs': '0',
	                  'objects': '23289',
	                  'ongoing_write_reqs': '0',
	                  'partition_absent': '2668',
	                  'partition_actual': '2834',
	                  'partition_desync': '0',
	                  'partition_object_count': '23289',
	                  'partition_ref_count': '8192',
	                  'partition_replica': '2690',
	                  'partition_zombie': '0',
	                  'paxos_principal': '3001:0d39073197a375aaf7df9fbb61e60067',
	                  'proxy_action': '5864',
	                  'proxy_in_progress': '0',
	                  'proxy_initiate': '11744',
	                  'proxy_retry': '0',
	                  'proxy_retry_new_dest': '0',
	                  'proxy_retry_q_full': '0',
	                  'proxy_retry_same_dest': '0',
	                  'proxy_unproxy': '0',
	                  'query_abort': '0',
	                  'query_agg': '0',
	                  'query_agg_abort': '0',
	                  'query_agg_avg_rec_count': '0',
	                  'query_agg_err': '0',
	                  'query_agg_success': '0',
	                  'query_avg_rec_count': '0',
	                  'query_fail': '0',
	                  'query_long_queue_full': '0',
	                  'query_long_reqs': '0',
	                  'query_long_running': '0',
	                  'query_lookup_abort': '0',
	                  'query_lookup_avg_rec_count': '0',
	                  'query_lookup_err': '0',
	                  'query_lookup_success': '0',
	                  'query_lookups': '0',
	                  'query_reqs': '0',
	                  'query_short_queue_full': '0',
	                  'query_short_reqs': '0',
	                  'query_short_running': '0',
	                  'query_success': '0',
	                  'queue': '0',
	                  'read_dup_prole': '0',
	                  'reaped_fds': '0',
	                  'record_locks': '0',
	                  'record_refs': '23289',
	                  'rw_err_ack_badnode': '0',
	                  'rw_err_ack_internal': '0',
	                  'rw_err_ack_nomatch': '0',
	                  'rw_err_dup_cluster_key': '0',
	                  'rw_err_dup_internal': '0',
	                  'rw_err_dup_send': '0',
	                  'rw_err_write_cluster_key': '0',
	                  'rw_err_write_internal': '0',
	                  'rw_err_write_send': '0',
	                  'scans_active': '0',
	                  'sindex-used-bytes-memory': '73984',
	                  'sindex_gc_activity_dur': '145',
	                  'sindex_gc_garbage_cleaned': '0',
	                  'sindex_gc_garbage_found': '0',
	                  'sindex_gc_inactivity_dur': '23242855',
	                  'sindex_gc_list_creation_time': '92',
	                  'sindex_gc_list_deletion_time': '8',
	                  'sindex_gc_locktimedout': '0',
	                  'sindex_gc_objects_validated': '0',
	                  'sindex_ucgarbage_found': '0',
	                  'stat_cluster_key_err_ack_dup_trans_reenqueue': '0',
	                  'stat_compressed_pkts_received': '0',
	                  'stat_delete_success': '0',
	                  'stat_deleted_set_objects': '0',
	                  'stat_duplicate_operation': '0',
	                  'stat_evicted_objects': '0',
	                  'stat_evicted_objects_time': '0',
	                  'stat_expired_objects': '0',
	                  'stat_ldt_proxy': '0',
	                  'stat_nsup_deletes_not_shipped': '0',
	                  'stat_proxy_errs': '0',
	                  'stat_proxy_reqs': '11744',
	                  'stat_proxy_reqs_xdr': '0',
	                  'stat_proxy_success': '11744',
	                  'stat_read_errs_notfound': '0',
	                  'stat_read_errs_other': '0',
	                  'stat_read_reqs': '0',
	                  'stat_read_reqs_xdr': '0',
	                  'stat_read_success': '0',
	                  'stat_rw_timeout': '0',
	                  'stat_write_errs': '0',
	                  'stat_write_errs_notfound': '0',
	                  'stat_write_errs_other': '0',
	                  'stat_write_reqs': '12013',
	                  'stat_write_reqs_xdr': '0',
	                  'stat_write_success': '12013',
	                  'stat_xdr_pipe_miss': '0',
	                  'stat_xdr_pipe_writes': '0',
	                  'stat_zero_bin_records': '0',
	                  'storage_defrag_corrupt_record': '0',
	                  'sub-records': '0',
	                  'system_free_mem_pct': '99',
	                  'system_swapping': 'false',
	                  'total-bytes-disk': '0',
	                  'total-bytes-memory': '8589934592',
	                  'transactions': '18492',
	                  'tree_count': '0',
	                  'udf_bg_scans_failed': '0',
	                  'udf_bg_scans_succeeded': '0',
	                  'udf_delete_err_others': '0',
	                  'udf_delete_reqs': '0',
	                  'udf_delete_success': '0',
	                  'udf_lua_errs': '0',
	                  'udf_query_rec_reqs': '0',
	                  'udf_read_errs_other': '0',
	                  'udf_read_reqs': '0',
	                  'udf_read_success': '0',
	                  'udf_replica_writes': '0',
	                  'udf_scan_rec_reqs': '0',
	                  'udf_write_err_others': '0',
	                  'udf_write_reqs': '0',
	                  'udf_write_success': '0',
	                  'uptime': '23616',
	                  'used-bytes-disk': '0',
	                  'used-bytes-memory': '3668233',
	                  'waiting_transactions': '0',
	                  'write_master': '12013',
	                  'write_prole': '11276'},
	  'succession-list': '3001:0d39073197a375aaf7df9fbb61e60067,3001:067df70da67cd6c36ad7b910bb959938,3001:efba5fc8eb3db7fff983c6fc82ccf177',
	  'system': { 'CPU information': [ 'CPUInfoBase__get_nbits=64',
	                                   'getNCPUs=4',
	                                   'has_mmx',
	                                   'has_sse',
	                                   'has_sse2',
	                                   'has_sse3',
	                                   'has_ssse3',
	                                   'is_64bit',
	                                   'is_Intel',
	                                   'is_i686',
	                                   [ { 'address sizes': '36 bits physical, 48 bits virtual',
	                                       'apicid': '0',
	                                       'bogomips': '6418.90',
	                                       'cache size': '6144 KB',
	                                       'cache_alignment': '64',
	                                       'clflush size': '64',
	                                       'core id': '0',
	                                       'cpu MHz': '1600.000',
	                                       'cpu cores': '4',
	                                       'cpu family': '6',
	                                       'cpuid level': '13',
	                                       'flags': 'fpu vme de pse tsc msr pae mce cx8 apic mtrr pge mca cmov pat pse36 clflush dts acpi mmx fxsr sse sse2 ss ht tm pbe syscall nx rdtscp lm constant_tsc arch_perfmon pebs bts rep_good xtopology nonstop_tsc aperfmperf pni pclmulqdq dtes64 monitor ds_cpl vmx smx est tm2 ssse3 cx16 xtpr pdcm sse4_1 sse4_2 x2apic popcnt aes xsave avx f16c rdrand lahf_lm ida arat epb xsaveopt pln pts dts tpr_shadow vnmi flexpriority ept vpid fsgsbase smep erms',
	                                       'fpu': 'yes',
	                                       'fpu_exception': 'yes',
	                                       'initial apicid': '0',
	                                       'model': '58',
	                                       'model name': 'Intel(R) Core(TM) i5-3470 CPU @ 3.20GHz',
	                                       'physical id': '0',
	                                       'power management': '',
	                                       'processor': '0',
	                                       'siblings': '4',
	                                       'stepping': '9',
	                                       'uname_m': 'x86_64',
	                                       'vendor_id': 'GenuineIntel',
	                                       'wp': 'yes'},
	                                     { 'address sizes': '36 bits physical, 48 bits virtual',
	                                       'apicid': '2',
	                                       'bogomips': '6418.90',
	                                       'cache size': '6144 KB',
	                                       'cache_alignment': '64',
	                                       'clflush size': '64',
	                                       'core id': '1',
	                                       'cpu MHz': '1600.000',
	                                       'cpu cores': '4',
	                                       'cpu family': '6',
	                                       'cpuid level': '13',
	                                       'flags': 'fpu vme de pse tsc msr pae mce cx8 apic mtrr pge mca cmov pat pse36 clflush dts acpi mmx fxsr sse sse2 ss ht tm pbe syscall nx rdtscp lm constant_tsc arch_perfmon pebs bts rep_good xtopology nonstop_tsc aperfmperf pni pclmulqdq dtes64 monitor ds_cpl vmx smx est tm2 ssse3 cx16 xtpr pdcm sse4_1 sse4_2 x2apic popcnt aes xsave avx f16c rdrand lahf_lm ida arat epb xsaveopt pln pts dts tpr_shadow vnmi flexpriority ept vpid fsgsbase smep erms',
	                                       'fpu': 'yes',
	                                       'fpu_exception': 'yes',
	                                       'initial apicid': '2',
	                                       'model': '58',
	                                       'model name': 'Intel(R) Core(TM) i5-3470 CPU @ 3.20GHz',
	                                       'physical id': '0',
	                                       'power management': '',
	                                       'processor': '1',
	                                       'siblings': '4',
	                                       'stepping': '9',
	                                       'vendor_id': 'GenuineIntel',
	                                       'wp': 'yes'},
	                                     { 'address sizes': '36 bits physical, 48 bits virtual',
	                                       'apicid': '4',
	                                       'bogomips': '6418.90',
	                                       'cache size': '6144 KB',
	                                       'cache_alignment': '64',
	                                       'clflush size': '64',
	                                       'core id': '2',
	                                       'cpu MHz': '1600.000',
	                                       'cpu cores': '4',
	                                       'cpu family': '6',
	                                       'cpuid level': '13',
	                                       'flags': 'fpu vme de pse tsc msr pae mce cx8 apic mtrr pge mca cmov pat pse36 clflush dts acpi mmx fxsr sse sse2 ss ht tm pbe syscall nx rdtscp lm constant_tsc arch_perfmon pebs bts rep_good xtopology nonstop_tsc aperfmperf pni pclmulqdq dtes64 monitor ds_cpl vmx smx est tm2 ssse3 cx16 xtpr pdcm sse4_1 sse4_2 x2apic popcnt aes xsave avx f16c rdrand lahf_lm ida arat epb xsaveopt pln pts dts tpr_shadow vnmi flexpriority ept vpid fsgsbase smep erms',
	                                       'fpu': 'yes',
	                                       'fpu_exception': 'yes',
	                                       'initial apicid': '4',
	                                       'model': '58',
	                                       'model name': 'Intel(R) Core(TM) i5-3470 CPU @ 3.20GHz',
	                                       'physical id': '0',
	                                       'power management': '',
	                                       'processor': '2',
	                                       'siblings': '4',
	                                       'stepping': '9',
	                                       'vendor_id': 'GenuineIntel',
	                                       'wp': 'yes'},
	                                     { 'address sizes': '36 bits physical, 48 bits virtual',
	                                       'apicid': '6',
	                                       'bogomips': '6418.90',
	                                       'cache size': '6144 KB',
	                                       'cache_alignment': '64',
	                                       'clflush size': '64',
	                                       'core id': '3',
	                                       'cpu MHz': '3201.000',
	                                       'cpu cores': '4',
	                                       'cpu family': '6',
	                                       'cpuid level': '13',
	                                       'flags': 'fpu vme de pse tsc msr pae mce cx8 apic mtrr pge mca cmov pat pse36 clflush dts acpi mmx fxsr sse sse2 ss ht tm pbe syscall nx rdtscp lm constant_tsc arch_perfmon pebs bts rep_good xtopology nonstop_tsc aperfmperf pni pclmulqdq dtes64 monitor ds_cpl vmx smx est tm2 ssse3 cx16 xtpr pdcm sse4_1 sse4_2 x2apic popcnt aes xsave avx f16c rdrand lahf_lm ida arat epb xsaveopt pln pts dts tpr_shadow vnmi flexpriority ept vpid fsgsbase smep erms',
	                                       'fpu': 'yes',
	                                       'fpu_exception': 'yes',
	                                       'initial apicid': '6',
	                                       'model': '58',
	                                       'model name': 'Intel(R) Core(TM) i5-3470 CPU @ 3.20GHz',
	                                       'physical id': '0',
	                                       'power management': '',
	                                       'processor': '3',
	                                       'siblings': '4',
	                                       'stepping': '9',
	                                       'vendor_id': 'GenuineIntel',
	                                       'wp': 'yes'}]],
	              'linux_distribution': ('CentOS', '6.3', 'Final'),
	              'os-name': 'posix',
	              'platform': 'linux2',
	              'uname': [ 'Linux',
	                         'fa56b8fc724c2a681736c0d122336b98',
	                         '2.6.32-279.19.1.el6.x86_64',
	                         '#1 SMP Wed Dec 19 07:05:20 UTC 2012',
	                         'x86_64',
	                         'x86_64']},
	  'telemetry-agent-ip-address': '0db488a85bf519ebd3d5c8e16ecaf097',
	  'telemetry-agent-version': '1.0.0',
	  'udfs': { 'num-udf-files': '1'},
	  'unix-epoch-time': '1457142263'}
